<?php

class EWRporta_DataWriter_Modules extends XenForo_DataWriter
{
	protected $_existingDataErrorPhrase = 'requested_page_not_found';

	protected function _getFields()
	{
		return array(
			'EWRporta_modules' => array(
				'module_name'		=> array('type' => self::TYPE_STRING, 'required' => true),
				'module_order'		=> array('type' => self::TYPE_UINT, 'required' => true, 'default' => 0),
				'module_position'	=> array('type' => self::TYPE_STRING, 'required' => true, 'default' => 'disabled',
					'allowedValues' => array('top', 'bottom', 'left', 'center', 'right', 'disabled'),
				),
				'module_cache'		=> array('type' => self::TYPE_STRING, 'required' => true, 'default' => '+10 minutes'),
				'module_show'		=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),
				'module_hide'		=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),
				'module_locked'		=> array('type' => self::TYPE_UINT, 'required' => false, 'default' => 0),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$modName = $this->_getExistingPrimaryKey($data, 'module_name'))
		{
			return false;
		}

		return array('EWRporta_modules' => $this->getModelFromCache('EWRporta_Model_Modules')->getModuleByName($modName));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'module_name = ' . $this->_db->quote($this->getExisting('module_name'));
	}


}